﻿using System;
using System.Text;

namespace gov.va.med.VBECS.Communication.Common
{
    /// <summary>
    /// This class represents an error. Instead of returning message data it throws exception.
    /// </summary>
    [Serializable]
    public class ErrorMessage : BaseMessage
    {
        private readonly Exception _exception;

        /// <summary>
        /// Constructor
        /// </summary>
        /// <param name="exception">Exception that represents an error</param>
        public ErrorMessage(Exception exception)
        {
            if(exception == null)
                throw new ArgumentNullException("exception");
            _exception = exception;
        }

        public override string ToString()
        {
            return _exception.Message;
        }

        /// <summary>
        /// Instead of returning message data this method throws exception.
        /// </summary>
        /// <returns>Throws exception</returns>
        public override byte[] GetBytes()
        {
            throw _exception;
        }

    }
}
